#Muna Aghaalnemer
#Text Adventure project
#Using Python 3
#text file name is "?muna's game"

import random
import time 

class State:
    def __init__(self, name, description):
        self.name = name
        self.description = description
        self.edges = []
        self.objects = []
        self.constraints = []
        
class Edge:
    def __init__(self, name, from_node, commands, to_node, description, health=None, constraints = None):
        self.name = name
        self.from_node = from_node 
        self.commands = commands
        self.to_node = to_node
        self.description = description
        self.constraints = constraints
        self.health = health 

class Objects:
    def __init__(self, location, name, shortdesc, description, weight):
        self.location = location
        self.name = name
        self.shortdesc = shortdesc
        self.description= description
        self.weight = weight


class Constraints:
    def __init__(self, name, obj_location, backpack,weight):
        self.name= name
        self.obj_location = obj_location
        self.weight = weight
        self.backpack = backpack

class Backpack:
    def __init__(self, objects=None):
        self.objects = []
        
class Engine:
    def __init__(self, filename, counter=0, initial_time=0, health=None ):
        self.filename = filename
        self.initial_state = None
        self.backpack = []
        self.counter = 0
        self.initial_time = time.time() 
        self.health = 15
        self.name = (" ")
	

    def load(self):
        self.states = {}
        edges = []
        objects = []
        constraints = []
        fp = open(self.filename)
        for line in fp:
            if len(line) == 0 or line[0] == '#':
                continue
            items = line.strip().split("::")
            if items[0] == 'node':
                s = State(*items[1:])
                if self.initial_state is None:
                    self.initial_state = s
                self.states[items[1]] = s
            elif items[0] == 'edge':
                edges.append(Edge(*items[1:]))
            elif items[0] == 'object':
                objects.append(Objects(*items[1:]))
            elif items[0] == 'constraint':
                constraints.append(Constraints(*items[1:]))
        for edge in edges:
            self.states[edge.from_node].edges.append(edge)
        for obj in objects:
            self.states[obj.location].objects.append(obj)
        for constraint in constraints:
            self.states[obj.location].constraints.append(obj)
        if self.health < 5:
            print ("Your life is in danger, you have 5 heallth points left")
            
            
            
    def play(self): 
        current_state = self.initial_state
        current_time = self.initial_time
        current_health = self.health
        backpack = Backpack()
        self.name = input("Please enter your name, if you wish to play ")
        print ("Hello,", self.name, "let's start the game")
        def linebreak(text, col= 27):
            retval= ""
            count = 0
            for c in text:
                if count >col and c ==" ":
                    retval += "\n"
                    count = 0
                else:
                    retval += str(c)
                    count +=1
            return retval 
        while True:
            print(linebreak(current_state.description))
            command = input("Command> ")
            c = command.split()
            for edge in current_state.edges:
                if command in edge.commands:
                    print(linebreak(edge.description))
                    current_state = self.states[edge.to_node]
                    self.count = 1
            for obj in current_state.objects:
                if c[0] == 'pick up':
                    if [1] in obj.name:
                        obj_location = Backpack()
                        backpack.objects.append(obj)
                        current_state.objects.remove(obj)
                        print("you now have",obj.name," it in your backpack")
                            
                if c[0] == 'look in backpack':
                    print ("You have", self.backpack, "with you")
                    
                if c[0] == 'drop':
                    if c[1] in obj.name:
                        obj_location = current_state.name
                        current_state.objects.append(obj)
                        backpack.Objects.remove(obj)
                        print("You no longer have the", obj.name, "in your backpack")

                if c[0] == ' look around' or 'look':
                    print (linebreak(current_state.objects))
                if self.health < 3 or self.health == 0:
                    input ("Game Over! Would you like to play again? Yes?No?Maybe?You Don't know?")
                    if c[0]== "Yes":
                        play()
                        break
                    elif [0] == "No":
                        print ("Your prince is never going to be rescued. ByeBye")
                        break
            if c[0] == 'Quit':
                print ("okay byebye!")
                break 


        
game = Engine("muna's_game.txt")
game.load()
game.play()
